//
//  CRTextGenerator.h
//  PhotoStyler
//
//  Created by Yaroslav Glushchenko on 9/9/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

extern NSString* const CRTextGeneratorTextKey;
extern NSString* const CRTextGeneratorRotationAngleKey;
extern NSString* const CRTextGeneratorTextRectKey;

//////////////////////////////////////////////////////////////////////
// Text texture generator
//////////////////////////////////////////////////////////////////////
@interface CRTextGenerator : CRImageProcessor
{
	NSImage*	workingImage;
	NSShadow*	textShadow;
}

@property (nonatomic, strong) NSAttributedString*	text;
@property (nonatomic, assign) CGFloat				rotationAngle;
@property (nonatomic, assign) NSRect				textRect;			// relative rect. origin is an offset from anchor point
@property (nonatomic, assign) NSRect				overRect;			// absolute rect. smart wrapper around the textRect

+ (CRTextGenerator *)generator;

@end